/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

#ifndef __DEBUG_MALLOC_H
#define __DEBUG_MALLOC_H

/************************************************************************
  Header file for debugging malloc

**********************************************************************/

// This changes the memory allocation stuff to print out what it is
// doing to allow us to debug the possible memory leak
#ifdef DEBUG_MEMORY
extern int global_cnt;
#endif

/// Wrapper for malloc to help debug a possible memory leak
/*@Doc: This function should be called instead of malloc so that
when the DEBUG\_MEMORY flag is set the global memory useage counter,
{\it global\_cnt}, is incremented.  This counter shows how many more
times {\tt malloc()} has been called than {\tt free()}. */
inline void *debug_malloc(size_t size)
{
#ifdef DEBUG_MEMORY
	global_cnt++;
#endif
	return malloc(size);
}

/// Wrapper for free to help debug a possible memory leak 
/*@Doc: This function should be called instead of free so that when
the DEBUG\_MEMORY flag is set the global memory useage counter, {\it
global\_cnt}, is decremented.  This counter shows how many more times
{\tt malloc()} has been called than {\tt free()}. */
inline void debug_free(void *ptr) {
#ifdef DEBUG_MEMORY
	global_cnt--; 
#endif 
	free(ptr); 
}

#endif // DEBUG_MALLOC_H







