/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

#ifndef __FITNESS_H
#define __FITNESS_H
/*********************************************************************
  The Fitness class

  *******************************************************************/

#include "object.H"

/// Holds information about the fitness of the evaluated program
/*@Doc: This class contains the results of the evaluation.  The
  fitness score is used to select which programs to breed next, and
  the hits are used to show the user of the program how it is
  proceeding */
class GFitness : public GObject
{
public:
	/// The number of times the program provided an exact solution
	int hits;
	/// The fitness score of the program, higher is better
	double fitness;

	/*@ManMemo: A constructor that takes the initial settings as
	  optional input.  If the optional arguments are not provided the
	  values are set to invalid settings to be caught later */
	GFitness(int ahits = -1, double afitness = -1.0);
	
	/// Set all of the values back to the initial states
	void Reset();
	/// Add two fitness classes by summing all of the values they contain
	GFitness operator+(GFitness &);
	/// Subract all of the fitness scores in one class from the other
	GFitness& operator+=(GFitness &);
	/// Copy a fitness class
	GFitness& operator=(GFitness &);
};

#endif // __FITNESS_H
