/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

/************************************************************************
 Member functions for the Fitness class
 The base class for anything requitring fitness scores.
 **********************************************************************/

#include "fitness.H"

// constructor
GFitness::GFitness(int ahits, double afitness)
{
	hits = ahits;
	fitness = afitness;
}

// reset fitness to initial state
void GFitness::Reset()
{
	hits = 0;
	fitness = (double)0.0;

	return;
}

// overloaded addition operator
GFitness GFitness::operator+(GFitness &a)
{
	GFitness r;

	r.fitness = a.fitness + fitness;
	r.hits = a.hits + hits;

	return r;
}

// overloaded addition/assignment operator
GFitness& GFitness::operator+=(GFitness &a)
{
	fitness += a.fitness;
	hits += a.hits;

	return *this;
}

// overloaded assignment operator
GFitness& GFitness::operator=(GFitness &a)
{
	fitness = a.fitness;
	hits = a.hits;

	return *this;
}
