/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

/************************************************************************
 Member functions for the Generation class

 This class holds all the information about a particular generation
 of programs and contains functions to evaluate, mutate and report on
 the programs.

 **********************************************************************/

#include "generation.H"

// constructor
GGeneration::GGeneration()
{
}

// destructor
GGeneration::~GGeneration()
{
}

// add model to the model list to use in evaluation
void GGeneration::AddModel(GModel *new_model)
{
	models.Append(new_model);
}

// return the current generation
int GGeneration::GetGeneration()
{
	return generation_num;
}

// return the number of programs in the generation
int GGeneration::GetNumProgs()
{
	return programs.GetSize();
}
// allow external objects to examine the programs
// TODO: this should return a copy of the tree
GProgram *GGeneration::GetProgram(int prog_num)
{
	if (prog_num < programs.GetSize()) return programs[prog_num];
	else return NULL;
}

#ifdef DEBUG_GENERATION
// allows test generation to cross individual programs
void GGeneration::TestCrossover(int prog_id1, int prog_id2)
{
	Crossover(prog_id1, prog_id2);
}

// allows test generation to cross individual programs
void GGeneration::TestSelect(int prog_id1)
{
	Select(prog_id1);
}                                      
#endif // DEBUG_GENERATION
