/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

/************************************************************************
  Member functions for the Generation class
  Handle the generation of fitness rankings

    This class holds all the information about a particular generation
  of programs and contains functions to evaluate, mutate and report on
  the programs.

  **********************************************************************/

#include "generation.H"

// compare the two fitness scores (see qsort man page for details)
// note we are returning the opposite of what is expected so the
// array is sorted in descending order
int comp_fit(GProgFit **a, GProgFit **b)
{
#ifdef ABSOLUTE
    if ((**a).fitness > (**b).fitness)
#else
	if ((**a).fitness < (**b).fitness)
#endif //ABSOLUTE
		return 1;
	if ((**a).fitness == (**b).fitness)
		return 0;

	return -1;
}

/*****************************************************************
  Return the ranking of the programs
  
  These are sorted in descending order
  *****************************************************************/
void GGeneration::Rank(GArray<GProgFit> &ranks)
{	
	// build the array of ranks
	for(int i=0; i < programs.GetSize(); i++)
		ranks[i] = new GProgFit(i, programs[i]->fit.hits, 
								  programs[i]->fit.fitness);

	// sort the array of ranks
	ranks.Sort((int (*)(const void *, const void *))comp_fit);
}
