/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

#ifndef __MESSAGE_H
#define __MESSAGE_H

/***************************************************************************
  GMessage - Message class

  This allows nodes to pass messages between nodes.
 **************************************************************************/

/* prerequisites */
#include "generic.H"
#include "object.H"

/// Class to allow messages to be passed between nodes
class GMessage : public GObject
{
public:
	/// The message type
	int message_id;
	/// The message body
	int message;

	/// The constructor takes the message id and message as optional arguments
	GMessage(int msg_id = -1, int msg = -1)
	{
		message_id = msg_id;
		message = msg;
	}
};

#endif //__Message_H
