/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

#ifndef __NETNODE_H
#define __NETNODE_H

/***************************************************************************
  GNetNode - Functions to manipulate the network nodes.

 **************************************************************************/

/* prerequisites */
#include "generic.H"
#include "object.H"
#include "pipe.H"
#include "network.H"

class GNetwork;					// to prevent a circular declaration

/// Defines the nodes in a network
/*@Doc: Provides the encapsulation of a complete node.  Thde node
  consists two arrays that define the pipes that flow into the node
  and flow out. */
class GNetNode : public GObject
{
	/// Pipes that flow into the node
	GArray<GPipe> in_pipes;
	/// Pipes that flow out from the node
	GArray<GPipe> out_pipes;

public:
	///
	GNetNode();
	///
	~GNetNode();
	
	/// Reset flow to zero
	void Reset();

	/// Increase the flow on the specified pipe by 1
    int IncreaseFlow(int pipe, int issource);
	/// Decrease the flow on the specified pipe by 1
	int DecreaseFlow(int pipe);
	/// Returns the flow on the specified input pipe
	int QueryInputFlow(int pipe);
	/// Returns the flow on the specified output pipe
	int QueryOutputFlow(int pipe);
	/// Returns the number of input pipes
	int QueryNumInPipes();
	/// Returns the number of output pipes
	int QueryNumOutPipes();
	/// Returns the capacity of the specified input pipe
	int QueryCapacityIn(int pipe);
	/// Returns the capacity of the specified output pipe
	int QueryCapacityOut(int pipe);
	/// Sends msg out along output pipe pipe with id msg_id
	int SendMessageOut(int pipe, int msg_id, int msg);
	/// Sends msg out along input pipe pipe with id msg_id
	int SendMessageIn(int pipe, int msg_id, int msg);
	/// Recieves output message of msg_id type on pipe pipe
	int RecieveMessageOut(int pipe, int msg_id, int &msg);
	/// Recieves input message of msg_id type on pipe pipe
	int RecieveMessageIn(int pipe, int msg_id, int &msg);

	/// Adds new pipe, pipe, either in (0) or out (1)
	int AddPipe(GPipe *pipe, int direction);

	/// Prints out this node
	void Print();

	/// Returns the destination of the specified pipe
	int GetDest(int pipe);
};

#endif //__NETNODE_H

