/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

/***************************************************************************
  GNetNode - Functions to manipulate the network nodes.

 **************************************************************************/

/* prerequisites */
#include "netnode.H"

GNetNode::GNetNode()
{
	in_pipes.SetSize(0);
	out_pipes.SetSize(0);
}

GNetNode::~GNetNode()
{
	// we don't delete these, the network does
	in_pipes.Clear();
	out_pipes.Clear();
}

void GNetNode::Reset()
{
}

int GNetNode::IncreaseFlow(int pipe, int issource)
{
	int i, avail = 0;

	// make sure there is enough flow in
	for(i=0; i < in_pipes.GetSize(); i++)
		avail += in_pipes[i]->QueryFlow();
	for(i=0; i < out_pipes.GetSize(); i++)
		avail -= out_pipes[i]->QueryFlow();

	if(avail > 0 || issource)
		return out_pipes[pipe]->ChangeFlow(1);
	else
		return 0;
}

int GNetNode::DecreaseFlow(int pipe)
{
	return out_pipes[pipe]->ChangeFlow(-1);
}

int GNetNode::QueryInputFlow(int pipe)
{
	return in_pipes[pipe]->QueryFlow();
}

int GNetNode::QueryOutputFlow(int pipe)
{
	return out_pipes[pipe]->QueryFlow();
}

int GNetNode::QueryNumInPipes()
{
	return in_pipes.GetSize();
}

int GNetNode::QueryNumOutPipes()
{
	return out_pipes.GetSize();
}

int GNetNode::QueryCapacityIn(int pipe)
{
	return in_pipes[pipe]->QueryCapacity();
}

int GNetNode::QueryCapacityOut(int pipe)
{
	return out_pipes[pipe]->QueryCapacity();
}

int GNetNode::SendMessageOut(int pipe, int msg_id, int msg)
{
	return out_pipes[pipe]->SendMessageOut(msg_id, msg);
}

int GNetNode::SendMessageIn(int pipe, int msg_id, int msg)
{
	return in_pipes[pipe]->SendMessageIn(msg_id, msg);
}

int GNetNode::RecieveMessageOut(int pipe, int msg_id, int &msg)
{
	return out_pipes[pipe]->RecieveMessageOut(msg_id, msg);
}

int GNetNode::RecieveMessageIn(int pipe, int msg_id, int &msg)
{
	return in_pipes[pipe]->RecieveMessageIn(msg_id, msg);
}

// adds new pipe, pipe, either in (0) or out (1)
int GNetNode::AddPipe(GPipe *pipe, int direction)
{
    switch (direction)
	{
	case 0:
		in_pipes.Append(pipe);
		break;
	case 1:
		out_pipes.Append(pipe);
		break;
	default:
		cerr << "GNetNode::AddPipe - invalid direction: " << direction 
			 << endl;
		exit(1);
	}

	return 0;
}

// prints out this node
void GNetNode::Print()
{
	int i;

	cout << "Pipes out:" << endl;
	for (i=0; i < out_pipes.GetSize(); i++)
		out_pipes[i]->Print();
	cout << "Pipes in:" << endl;
	for (i=0; i < in_pipes.GetSize(); i++)
		in_pipes[i]->Print();
}

// returns the destination of the specified pipe
int GNetNode::GetDest(int pipe)
{
	return out_pipes[pipe]->GetDest();
}
