/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

#ifndef __NETWORK_MODEL1_H
#define __NETWORK_MODEL1_H

/***************************************************************************
  GDistNetModel - Distributed network model

  Each node executes the instructions independent of the others.  There
  is no global overseer.
 **************************************************************************/

/* prerequisites */
#include "generic.H"
#include "model.H"
#include "network.H"
#include "eval_state.H"

/// The default value for the number of iterations a node can perform
#define DEFAULT_MAX_ITERATIONS 1000

/// Distributed network model with independently processing nodes
/*@Doc: This model simulates a network of independent nodes attempting
  to coordinate their efforts to maximize the flow from the source to
  the sink.  Each node executes the same evolved program and the
  fitness is based upon the throughput of the network.  */
class GDistNetModel : public GModel
{
	int var[2];

	/// The final result of the program
    int out;
	/// The current iteration
    int iteration;
	/// How many iterations to perform
    int max_iterations;
	/// Cache for the best flow possible in the network
	int best_flow;

	/// We can read from old_net
	GNetwork *old_net;
	/// and write to new_net to allow changes to be atomic
	GNetwork *new_net;

public:
	/*@ManMemo: Takes a model to use for evaluation and optionally 
	  the maximum iterations */
    GDistNetModel(int model, int max_iters = DEFAULT_MAX_ITERATIONS);

	///
    ~GDistNetModel();

    /// Evaluate an operator (called by GProgram)
    int Evaluate(GOperator *head);

    /// Evaluate an operator
    virtual GType *Evaluate(oper_enum operation, GArray<GType> &params, 
							int node);

	/// Return the next child to evaluate, or 0 when done 
	virtual int GetNext(oper_enum operation, int i, GType *retval);

    /// Returns the fitness for the last program run on this model
    virtual GFitness GetFitness();

    /// Decision function for length of runtime for a certain program
    virtual int Running();
};

#endif //__NETWORK_MODEL1_H
