/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

#ifndef __OBJECT_H
#define __OBJECT_H

/************************************************************************
  Header file for the Object class

    The base class for all other classes in the program.

  **********************************************************************/

#include <iostream.h>

// This is a cludge to ensure that every class gets the header files that 
// might be missing on that particular platform
#include "missing.H"

/// This is the root class for all other classes in the project
/*@Doc: If you create a new class in this program it should be derived
  from this class.  It need not be a direct link, but at least one of
  its ancestors sould be GObject.  This allows additional
  functionality to be added if necessary. */
class GObject
{
public:
	/*@ManMemo: this is for diagnostic purposes - you usually don't
	 want to see this in your stream. */
	friend ostream& operator<<(ostream& s, GObject&)
	{
		return s << "** Base Class GObject **" << endl;
	}
};

#endif
