/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

#ifndef __OPERATOR_H
#define __OPERATOR_H

/************************************************************************
  Operator class - holds the operator information for a particular
  instruction in the program tree.

  examples of interaction:

  children.GetSize();
  children[0] = new GOperator(OP_ADD_INT);              (creation)
  children[1] = anotherop->children[0];                 (crossover)
  Evaluate(model);                                      (evaluation)
  **********************************************************************/

/* prerequisites */
#include "generic.H"
#include "object.H"

// include the header file for the desired model
#if defined INT_MODEL
#include "type.H"
#include "optable.H"
#elif defined NET_MODEL
#include "type_net1.H"
#include "optable_net1.H"
#endif // NET_MODEL

/*@ManMemo: This class holds the operator information for a particular
  instruction in the program tree */
class GOperator : public GObject
{
	/// The operator type
	oper_enum type;

public:
	/// Array of child pointers
	GArray<GOperator> children;

	///
	GOperator(oper_enum optype);
	///
	GOperator(GOperator &op);
	///
	~GOperator();

	/// Assignment operator -- makes a copy of the operator and children
	GOperator &operator=(GOperator &op);

	/// Returns operator enum type 
	oper_enum GetOperatorType();
  
	/// Returns 0 if operator has invalid structure below the current operator
	int Valid();

	/// Returns the number of nodes beneath this one
	int GetLength();

	/* TODO: needs to use streams */
	/// Prints out the node and the calls the children to print
	void Print(int level = 0);
};

#endif
