/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

/************************************************************************
  Operator class - holds the operator information for a particular
  instruction in the program tree.
  **********************************************************************/

#include "operator.H"

/* constructor */
GOperator::GOperator(oper_enum optype)
{
	/* save operator type */
	type = optype;
}

// copy constructor
GOperator::GOperator(GOperator &op)
{
	*this = op;
}

// destructor
GOperator::~GOperator()
{
}

/* assignment operator -- makes a copy of the operator and children */
GOperator &GOperator::operator=(GOperator &op)
{
	// copy operator type
	type = op.type;

	// copy children
//	delete_array(children);
	for(int i=0; i<op.children.GetSize(); i++)
		children[i] = new GOperator(*op.children[i]);

	return *this;
}

/* returns operator enum type */
oper_enum GOperator::GetOperatorType()
{
	return type;
}
  
/* returns 0 if operator has invalid structure */
int GOperator::Valid()
{
	GOperator *child;
	int retval = 1;

	/* check number of children */
	if(children.GetSize() != optable.GetNumChildren(type))
	{
		retval = 0;

		cerr << "GOperator::Valid(): wrong number of children ("
		 	 << children.GetSize() << " != " 
		 	 << optable.GetNumChildren(type) << ")";
	}

	/* check types of children */
	for(int i=0; i<optable.GetNumChildren(type); i++)
    {
		child = children[i];
		if(optable.GetType(child->GetOperatorType()) != 
		   optable.GetChildType(type, i)) 
			{
				retval = 0;

				cerr << "GOperator::Valid(): wrong child types (child[" << i
					 << "] = " << (int)optable.GetType(child->GetOperatorType())
					 << ", != " << (int)optable.GetChildType(type, i) << ")";
			}
    }

	if(!retval)
		cerr << " in opcode " << optable.GetName(type) << endl;

	return retval;
}

// returns the number of nodes beneath this one
int GOperator::GetLength()
{
	int retval;					// the return value
	int i;
	
	retval = 1;
	for (i=0; i<children.GetSize(); i++)
		retval += children[i]->GetLength();

	return retval;
}

/* prints out the node and the calls the children to print */
/* do a prefix print so 1 + 2 + 3 ==> (+, (+, 1, 2), 2) */
void GOperator::Print(int level)
{
	int current;			// which child to print next
  
	cout << optable.GetName(type);
	for (current = 0; current < children.GetSize(); current++)
    {
		// indent if child is not leaf
		cout << endl;
		for(int i=0; i <= level; i++)
			cout << " ";
		children[current]->Print(level+1);
    }
}
