/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

/**************************************************************************
  GOperatorTable class - allows creation and querying of arbitrary
  operator types (without knowledge of derivation structure)
  ************************************************************************/

#include "optable.H"

/* global declaration of operator table */
GOperatorTable optable;

/* array containing number of children per operator */
int GOperatorTable::num_children[NUM_OPERATORS] =
{
	0,				// TYPE_INT OP_DATA_INT()
	2,				// TYPE_INT OP_ADD_INT(TYPE_INT, TYPE_INT)
	2,				// TYPE_INT OP_SUB_INT(TYPE_INT, TYPE_INT)
	2,				// TYPE_INT OP_MUL_INT(TYPE_INT, TYPE_INT)
	2,				// TYPE_INT OP_DIV_INT(TYPE_INT, TYPE_INT)
	1,			    // TYPE_INT OP_OUT_INT(TYPE_INT)
	0			    // TYPE_INT OP_IN_INT()
};

/* array containing types of operators and children */
type_enum GOperatorTable::types[NUM_OPERATORS][MAX_CHILDREN+1] =
{
	/* return_type, child1_type, child2_type ... */
	{ TYPE_INT },					        // OP_DATA_INT  
	{ TYPE_INT, TYPE_INT, TYPE_INT },		// OP_ADD_INT
	{ TYPE_INT, TYPE_INT, TYPE_INT },		// OP_SUB_INT
	{ TYPE_INT, TYPE_INT, TYPE_INT },		// OP_MUL_INT
	{ TYPE_INT, TYPE_INT, TYPE_INT },		// OP_DIV_INT
	{ TYPE_INT, TYPE_INT },                 // OP_OUT_INT
	{ TYPE_INT }				            // OP_IN_INT
};

/* array of operator names */
char *GOperatorTable::names[NUM_OPERATORS] = 
{
	"One",
	"Add",
	"Sub",
	"Mul",
	"Div",
	"Out",
	"In ",
};

/* array of conditional types */
int GOperatorTable::cond_type[NUM_OPERATORS] =
{
	0,				// TYPE_INT OP_DATA_INT()
	0,				// TYPE_INT OP_ADD_INT(TYPE_INT, TYPE_INT)
	0,				// TYPE_INT OP_SUB_INT(TYPE_INT, TYPE_INT)
	0,				// TYPE_INT OP_MUL_INT(TYPE_INT, TYPE_INT)
	0,				// TYPE_INT OP_DIV_INT(TYPE_INT, TYPE_INT)
	0,			    // TYPE_INT OP_OUT_INT(TYPE_INT)
	0			    // TYPE_INT OP_IN_INT()
};
