/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

#ifndef __PIPE_H
#define __PIPE_H

/***************************************************************************
  GPipe - Functions to manipulate pipes

 **************************************************************************/

/* prerequisites */
#include "queue.H"
#include "object.H"
#include "message.H"

/// The encapsulation of a pipe between two network nodes
class GPipe : public GObject
{
	/// The message queue on the pipe to the destination node
	GQueue<GMessage> out_queue[2];
	/// The message queue on the pipe to the source node
	GQueue<GMessage> in_queue[2];
	/// The current flow on this pipe
	int flow;					
	/// The maximum flow on this pipe
	int capacity;
	/// The source node of the pipe
	int source;
	/// The destination node of the pipe
	int dest;

public:
	/// Copy constructor
	GPipe(GPipe &input);
	/*@Memo: Takes the source, destination, and optionally the flow
      and capacity as arguments */
	GPipe(int s, int d, int f = 0, int c = 0);
	/// Destructor, frees the message queues
	~GPipe();
	/// Duplicates the pipe and its message queues
	GPipe& operator=(GPipe &input);

	/// Reset the flow information about a pipe (not capacity)
	void Reset();

	/// Modify the flow by the specified amount
    int ChangeFlow(int change);
	/// Set the capacity to the specified value
    int SetCapacity(int cap);
	/// Returns the current flow
	int QueryFlow();
	/// Returns the current capacity
	int QueryCapacity();
	/// Sends msg out with id msg_id
	int SendMessageOut(int msg_id, int msg);
	/// Sends msg in with id msg_id
	int SendMessageIn(int msg_id, int msg);
	/// Recieves message out
	int RecieveMessageOut(int msg_id, int &msg);
	/// Recieves message in
	int RecieveMessageIn(int msg_id, int &msg);

	/// Prints the status of the pipe
	void Print();

	/// Returns the source of the pipe
	int GetSource() { return source; };
	/// Returns the destination of the pipe
	int GetDest() { return dest; };
};

#endif //__PIPE_H
