/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

#ifndef __PROGFIT_H
#define __PROGFIT_H
/*********************************************************************
  Holds a program index and the fitness scores to allow for ranking
  *******************************************************************/

#include "fitness.H"

/*@ManMemo: This class relates the fitness scores with the program 
  index to allow for operations that do not maintain the order of the 
  fitness scores. */
class GProgFit : public GFitness
{
public:
	/*@Memo: Constructor that takes the program offset and optionally
      the hits and fitness */
	GProgFit(int aprog_off, int ahits = -1, double afitness = -1.0) 
		: GFitness(ahits, afitness)
	{
		prog_off = aprog_off;
	}
	
	/// The program offset (index)
    int prog_off;
};

#endif // __PROGFIT_H
