/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

#ifndef __PROGRAM_H
#define __PROGRAM_H

/************************************************************************
  Header file for the Program class

    This class holds all the information necessary to run a particular
  program.

  **********************************************************************/

#include "generic.H"
#include "object.H"
#include "operator.H"
#include "model.H"
#include "fitness.H"

/// An encapsulation of the information necessary to run a program
class GProgram : public GObject
{
	/// The root of the program tree
	GOperator *tree_root;

public:
	/// Fitness scores, for each model
	GArray<GFitness> fit_array;
	/// Overall fitness
	GFitness fit;
	
	/// Constructor that takes the specified tree root
	GProgram(GOperator *atree_root = NULL);
	/// Copy constructor that duplicates the given program 
	GProgram(GProgram &program);
	/// Destructor that frees the operator tree and fitness array
	~GProgram();

	/// Assignment operator -- copies operator tree
	GProgram &operator=(GProgram &x);
	
	/// Evaluate this program
	void Evaluate(GArray<GModel> &model);

	/// Get the root of the program tree
	GOperator* GetRoot();

	/// Set the program tree root
	void SetRoot(GOperator *root);

	/// Get the length of the program (the number of nodes)
	int GetLength();
};

#endif // __PROGRAM_H
