/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

/************************************************************************
  The member functions for the Program class

    This class holds all the information necessary to run a particular
  program.

  **********************************************************************/

#include "program.H"

// recursive operator tree copier
GOperator *recursive_copy(GOperator *tree)
{
	GOperator *new_tree = new GOperator(tree->GetOperatorType());
	
	// for each child, copy tree
	for(int i = 0; i < tree->children.GetSize(); i++)
		new_tree->children[i] = recursive_copy(tree->children[i]);

	return new_tree;
}

// constructor
GProgram::GProgram(GOperator *atree_root)
{
	SetRoot(atree_root);
}

// copy constructor -- doesn't copy fitness
GProgram::GProgram(GProgram &aprogram)
{
	// make copy of operator tree
	SetRoot(NULL);
	*this = aprogram;
}

// destructor
GProgram::~GProgram()
{
	delete tree_root;
}

// evaluate this program
void GProgram::Evaluate(GArray<GModel> &models)
{
	// reset overall fitness, clear fitness array
	fit.Reset();

	// evaluate using all given models
	for(int i = 0; i < models.GetSize(); i++)
    {
		// evaluate the program
		// this is being removed to allow for parallel evaluation
		// delete tree_root->Evaluate(models[i]);
		// now we call let the model evaluate the operator tree
		models[i]->Evaluate(tree_root);

		// save the fitneess in the fitness array, and keep a total
		fit_array[i] = new GFitness(models[i]->GetFitness());
		fit += *(fit_array[i]);
    }
}

// get the root of the program tree
GOperator *GProgram::GetRoot()
{
	return tree_root;
}

// get the root of the program tree
int GProgram::GetLength()
{
	return tree_root->GetLength();
}

// set the program tree root
void GProgram::SetRoot(GOperator *root)
{
	tree_root = root;
}

// assignment operator - copies operator tree
GProgram &GProgram::operator=(GProgram &x)
{
	// delete old stuff
	delete tree_root;

	// create new copy of tree
	SetRoot(recursive_copy(x.GetRoot()));

	return *this;
}
