/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

/**********************************************************************
  Test routines for the Generation class.

  ********************************************************************/

#ifdef WIN32
#include <process.h>			// getpid()
#else
#include <unistd.h>				// getpid()
#endif
#include <stdlib.h>				// srandom()
#include "test_model.H"
#include "generation.H"
#include "progfit.H"

#define NUM_TEST_PROGS 10

/* display the contents of the programs */
void print_progs(GGeneration &test_gen)
{
	for(int i=0; i < NUM_TEST_PROGS; i++)
	{
		test_gen.GetProgram(i)->GetRoot()->Print();
		cout << endl << endl;
	}
}

int main()
{
	GTestModel test_model;
	GGeneration test_gen;
	GArray<GProgFit> ranks;
	int i;
	
	// initialize the random number generator
	srand(getpid());

	// add the test model to the generation
	cout << "Setting Model" << endl << endl;
	test_gen.AddModel(&test_model);

	// make some test programs
	cout << "Generating Programs" << endl << endl;
	test_gen.GenerateNewGeneration(NUM_TEST_PROGS, 1, 3, (int)OP_OUT_INT);
	print_progs(test_gen);

	// rank programs
	cout << endl << endl << "Printing program ranking" << endl << endl;
	
	test_gen.Rank(ranks);
	for(i=0; i < ranks.GetSize(); i++)
	{
		// TODO: print rankings
		cout << ranks[i]->fitness << "\t " << ranks[i]->prog_off << endl;
	}

/*	// select the programs
	cout << endl << endl << "Selecting programs" << endl << endl;
	for (i=0; i < NUM_TEST_PROGS; i++)
		test_gen.TestSelect(i);
	print_progs(test_gen); */

	// breed programs
	cout << endl << endl << "Breeding programs" << endl << endl;
	test_gen.BreedNewGeneration(NUM_TEST_PROGS, 1, 1, 1);
	print_progs(test_gen);

	// rank programs
	cout << endl << endl << "Printing program ranking" << endl << endl;
	
	test_gen.Rank(ranks);
	cout << "Fitness\t Hits\t Prog ID\t Length" << endl;
	for(i=0; i < ranks.GetSize(); i++)
		cout << ranks[i]->fitness << "\t " << ranks[i]->hits
			 << "\t " << ranks[i]->prog_off << "\t\t " 
			 << test_gen.GetProgram(ranks[i]->prog_off)->GetRoot()->GetLength()
				 << endl;


	return 0;
}
