/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

#ifndef __TEST_MODEL_H
#define __TEST_MODEL_H

/***************************************************************************
  GTestModel class - test definition of model
 **************************************************************************/

/* prerequisites */
#include "generic.H"
#include "model.H"

#define DEFAULT_MAX_ITERATIONS 1000000
#define DEFAULT_INPUT 0

class GTestModel : public GModel
{
    int out;                          // the final result of the program
    int iteration;
    int max_iterations;
	int input;

	/* evaluate an operator (called recursively) */
	GType *Evaluate(oper_enum operation, GArray<GType> &params, int node);
	GType *Evaluate(GOperator *head, int tmp);
public:
    GTestModel(int inp = DEFAULT_INPUT, 
			   int max_iters = DEFAULT_MAX_ITERATIONS);

    /* evaluate an operator (called by GProgram) */
    virtual int Evaluate(GOperator *head);

	/* return the next child to evaluate, or 0 when done */
	virtual int GetNext(oper_enum operation, int last, GType *retval);

    /* returns the fitness for the last program run on this model */
    virtual GFitness GetFitness();

    /* decision function for length of runtime for a certain program */
    virtual int Running();
};

#endif //__TEST_MODEL_H
