/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

/**********************************************************************
  Test routines for the Generation class.

  ********************************************************************/

#ifdef WIN32
#include <process.h>			// getpid()
#else
#include <unistd.h>				// getpid()
#endif
#include <stdlib.h>				// srandom()

#include "network.H"

#define NUM_TEST_NODES 10

int main()
{
	GNetwork test_net;
	GNetwork test_net1;
	int i, mi=0, m=0;

	for (i=0; i < 3; i++)
		test_net.AddNode();

	test_net.SetSource(0);
	test_net.SetSink(2);
	test_net.AddPipe(0, 1, 10);
	test_net.AddPipe(1, 2, 10);
	test_net.SendMessageOut(0, 0, 1, 100);
	test_net.SendMessageOut(0, 0, 2, 50);
	test_net.SendMessageOut(0, 0, 1, 100);
	test_net.SendMessageOut(0, 0, 2, 50);
	test_net.SendMessageOut(0, 0, 1, 100);
	test_net.SendMessageOut(0, 0, 2, 50);

	test_net1 = test_net;

	test_net.RecieveMessageIn(1, 0, 1, m);
	test_net.RecieveMessageIn(1, 0, 1, m);
	test_net.RecieveMessageIn(1, 0, 2, m);
	test_net1.Print();
	test_net.Print();
	cout << "Message: " << m << "\tType: " << 0 << endl;

	return 0;
}
