/***************************************************************************
  This is part of the evolver toolkit for exploring genetic progamming.
  Copyright (C) 1996 Benjamin Bennett and Yeasah G. Pell

  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  Contact information: Benjamin Bennett<fiji@limey.net> and Yeasah
    G. Pell<yeasah@wpi.edu>
  *************************************************************************/

#ifndef __type_h
#define __type_h

/***************************************************************************
  Type class - encapsulates data passed between operators
  *************************************************************************/

/* prerequisites */
#include "generic.H"

/* SYSTEM DEFINE - total number of known types */
#define NUM_TYPES 1
    
/* type enumeration */
enum type_enum
{
	TYPE_INVALID=-1,
	TYPE_INT=0
};  

/* operator return type class */
class GType : public GObject
{
public:
	/* returns the type enumeration value */
	virtual type_enum GetType() = 0;

	/* gives a pointer to the data */
	virtual void *GetData() = 0;

	/* sets data given a pointer */
	virtual void SetData(void *adata) = 0;
};

/* integer class */
class GIntType : public GType
{
	/* data payload */
	int data;

public:
	GIntType(int adata)
	{
		data = adata;
	}

	virtual type_enum GetType()
	{
		return TYPE_INT;
	}

	virtual void *GetData()
	{
		return &data;
	}

	virtual void SetData(void *adata)
	{
		data = *((int *)adata);
	}
};

#endif
